/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.jsondefs;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.packloading.JSONParser;

public class JSONAnimationDefinition {
    @JSONParser.JSONRequired
    @JSONParser.JSONDescription(value="The type of animation this definition will perform.")
    public AnimationComponentType animationType;
    @JSONParser.JSONRequired
    @JSONParser.JSONDescription(value="The variable to use in animation.")
    public String variable;
    @JSONParser.JSONRequired(dependentField="animationType", dependentValues={"ROTATION", "SCALING"})
    @JSONParser.JSONDescription(value="The x, y, z position that this animation should be performed at.  If this is rotation, it is the rotation point.")
    public Point3D centerPoint;
    @JSONParser.JSONRequired(dependentField="animationType", dependentValues={"TRANSLATION", "ROTATION", "SCALING"})
    @JSONParser.JSONDescription(value="This is the most complex part of the animation system.  In essence, it is the vector about which this part will animate.  For translations, this is simply the direction the part will translate in.  For rotations, this is the axis the rotation is performed around, in a counter-clockwise direction (Right-Hand Rule).\nNormally, the amount an object moves is fixed.  However, if you wish to scale this movement you can multiply all the points of the axis to adjust the scale. For example, using the door variable will only rotate a door by 1 degree (because the door variable goes from 0 to 1).  However, if you multiply the axis by 60, it will then rotate 60 degrees.  This can be done for any variable and on any axis.\nNote that multi-axis rotation gets a fair bit more complicated.  If you only want an object to rotate in one axis, such as a door that's perfectly vertical, you only need to put a 60 in the Y spot and this will rotate the door about the vector pointing in the +Y direction.  If you put a -1 in the Y spot, then it will rotate about the -Y direction, which simply means it will be clockwise rather than counter-clockwise.\nHowever, with multiple axis on complex models, you'll find this single-value method won't work, and you'll need to calculate the proper axis.  This is done by taking the centerPoint, and a known point along the axis of rotation, and calculating the angles between them for the X, Y, and Z directions.  For a two-axis rotation this can be done with some simple trigonometry by finding the angle and using a sine and cosine function to get the components.\nFor a three-axis rotation (a part of a model that whose rotation axis cannot be restricted to a two-dimensional plane) this gets significantly more complex and can lead to you dealing with polar coordinates.  If you chose to do this, you can, but do note that if you don't have a good grasp of geometry you will have issues telling MTS what exactly you want it to do.  If worst comes to worst, you can ask the Discord team for help, and grab one of their auto-angle calculators.  But make sure your model is done and good before you get this far!")
    public Point3D axis;
    @JSONParser.JSONDescription(value="The offset for this animation.  This will add-on to the value returned by the variable.  Clamps are applied to the total value of the variable plus the offset.")
    public double offset;
    @JSONParser.JSONRequired(dependentField="animationType", dependentValues={"VISIBILITY"})
    @JSONParser.JSONDescription(value="If included, MTS will clamp the total animation value (the value of variable, times the scale, plus the offsets) to always be greater than this value.  If the animation is a visibility, this is the lowest value the object will be visible at.  If the animation is an inhibitor, this is the lowest value at which animations will be inhibited.")
    public double clampMin;
    @JSONParser.JSONRequired(dependentField="animationType", dependentValues={"VISIBILITY"})
    @JSONParser.JSONDescription(value="Like clampMin, but for the max value.")
    public double clampMax;
    @JSONParser.JSONDescription(value="If true, the absolute value of the variable will be used rather than the actual value.  Note that negative movements are still possible via a negative rotation factor or a large negative offset.")
    public boolean absolute;
    @JSONParser.JSONDescription(value="Used for VMs. If true, trig functions will be inverted.")
    public boolean invert;
    @JSONParser.JSONDescription(value="The duration of this animation, in ticks.  Causes the animation to be interpolated over the duration for smooth movement.  Useful for things like doors.  Only works for variables that go from 0-1.")
    public int duration;
    @JSONParser.JSONDescription(value="The type of easing interpolation to apply on the forwards animation.")
    public AnimationEasingType forwardsEasing;
    @JSONParser.JSONDescription(value="The type of easing interpolation to apply on the reverse animation.")
    public AnimationEasingType reverseEasing;
    @JSONParser.JSONDescription(value="How long this animation waits to start after the variable goes to 1, in ticks.  For example, an animation with a forwardsDelay of 20 and a duration of 40 would wait one second before moving, and then take two seconds to move its entire animation.")
    public int forwardsDelay;
    @JSONParser.JSONDescription(value="Like forwardsDelay, but for the end of the animation.  This delay is applied when the variable goes from 1 to 0.")
    public int reverseDelay;
    @JSONParser.JSONDescription(value="If true, this animation will skip the forward movement time specified in the duration and will instantly move to the end of the animation.  Useful when you want uni-directional animations.  Note that this does not prevent the movement delay from forwardsDelay from applying.  However, it will void any reverseDelay.")
    public boolean skipForwardsMovement;
    @JSONParser.JSONDescription(value="Like skipForwardsMovement, but for the reverse movement.")
    public boolean skipReverseMovement;
    @JSONParser.JSONDescription(value="This sound will play when the animation starts its movement forwards.  This only happens at the start of the duration, not the start of the delay.  Format is [packID:soundName]")
    public String forwardsStartSound;
    @JSONParser.JSONDescription(value="This sound will play when the animation ends its movement forwards.  This only happens at the end of the duration, and won't occur if the animation reverses direction beforehand.")
    public String forwardsEndSound;
    @JSONParser.JSONDescription(value="Like forwardsStartSound, but for reverse.")
    public String reverseStartSound;
    @JSONParser.JSONDescription(value="Like forwardsEndSound, but for reverse.")
    public String reverseEndSound;

    public static enum AnimationEasingType {
        LINEAR,
        EASEINSINE,
        EASEOUTSINE,
        EASEINOUTSINE,
        EASEINQUAD,
        EASEOUTQUAD,
        EASEINOUTQUAD,
        EASEINCUBIC,
        EASEOUTCUBIC,
        EASEINOUTCUBIC,
        EASEINQUART,
        EASEOUTQUART,
        EASEINOUTQUART,
        EASEINQUINT,
        EASEOUTQUINT,
        EASEINOUTQUINT,
        EASEINCIRC,
        EASEOUTCIRC,
        EASEINOUTCIRC,
        EASEINBACK,
        EASEOUTBACK,
        EASEINOUTBACK,
        EASEINELASTIC,
        EASEOUTELASTIC,
        EASEINOUTELASTIC,
        EASEINBOUNCE,
        EASEOUTBOUNCE,
        EASEINOUTBOUNCE;

    }

    public static enum AnimationComponentType {
        TRANSLATION,
        ROTATION,
        SCALING,
        VISIBILITY,
        INHIBITOR,
        ACTIVATOR;

    }
}

